<?php

namespace App\Http\Controllers\HospitalPortal;

use Helper;
use Library;
use Carbon\Carbon;
use App\Models\User;
use App\Services\Firebase;
use Illuminate\Http\Request;
use App\Models\Mobile_status;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\map_status_notif;
use App\Models\Notifikasi;
use Illuminate\Support\Facades\Http;
use App\Services\Validator\ValidatorManagerInterface;
use Exception;

class HospitalPortalController extends Controller
{
    public $me;
    public $firebase;
    public function __construct()
    {
        $this->me          = auth()->user();
        $this->firebase    = new Firebase();
    }
    public function hospitalPortal(Request $request)
    {
        Helper::Log("info", "Hospital Portal Request", ['request'=>$request->all(),'path'=>$request->url()]);
        $url = config('services.medikaplaza.hospital');
        // $conn = DB::connection('stag_medika');
        $sql_check = "SELECT
                    rp.card_number,
                    rp.program_plan_id,
                    cpp.mobile_service_type
                FROM
                    res_partner rp
                LEFT JOIN client_program_plan cpp ON
                    cpp.id = rp.program_plan_id
                WHERE
                    rp.card_number = '".$this->me->card_number."'
                    AND cpp.mobile_service_type = 'no'";
        $check = DB::select(DB::raw($sql_check));
        if ($check) {
            Helper::Log("warning","Error MpQris", ["message" => "MpQris not allowed"]);
            return Helper::generalResponse(false, 'not allowed', [], 400);
        }

        $rule = [
            'card_number'       => 'required',
            'claim_category'    => 'required',
            'provider'          => 'required',
            'admission_date'    => 'required|date_format:Y-m-d',
        ];
        try{
            app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);

            $card_number    = $request->card_number;
            $claim_category = $request->claim_category;
            $provider       = $request->provider;
            $admission_date = $request->admission_date;
            
            $payload = sprintf('{
                    "params": { 
                        "card_number": "%s",
                        "claim_category": "%s",
                        "provider": "%s",
                        "admission_date": "%s"
                        }
                    }', $card_number, $claim_category, $provider, $admission_date);
            Helper::Log("info", "Hospital Portal Payload", [$payload]);
            $response = Http::withBody(
                        $payload, 'text/plain'
                        )->post($url);
            $res = json_decode($response);
            if (!isset($res) || is_null($res)) {
                throw new \Exception("Hospital Portal Failed");
            }
            // //**Push notification */
            if(!!$res){
                $user = $this->firebase->getUserToken();
                try{
                    $sql = "SELECT
                                adm.id,
                                adm.claim_source,
                                adm.provider_id,
	                            rp.display_name 
                            FROM
                                mobile_apps_admission adm
                            LEFT JOIN res_partner rp ON 
	                            rp.id = adm.provider_id
                            WHERE 1=1
                                AND adm.card_number = '".$card_number."'
                                AND adm.claim_source = 'portal'
                            ORDER BY adm.id DESC
                            LIMIT 1";
                    $admission = DB::select(DB::raw($sql));
                    if (is_null($admission) || empty($admission)) {
                        Helper::Log('error', 'Portal tidak ditemukan', []);
                    }

                }catch(Exception $e){
                    Helper::Log('error', 'Get Portal to database Failed', $e->getMessage());
                }
                try{
                    $getStatus = map_status_notif::where("type","portal")->where("status","requested")->first();
                    $id_admission = $admission[0]->id ?? null;
                    $label  = $getStatus['label']??"Appointment Requested";
                    $provider = $admission[0]->display_name ?? "";
                    $date_now = Carbon::now()->isoFormat('D-MM-YYYY');
                    $text   = sprintf($getStatus['message']??"Your Appointment Requested has been successfully", $provider, $date_now);
        
                    $notif = [
                        'user'          => $user,
                        'id_admission'  => $id_admission,
                        'label'         => $label,
                        'type'          => "portal",
                        'text'          => $text,
                    ];
                    //**notification */
                    $this->firebase->pushNotif($notif);
                }catch(Exception $e){
                    report($e);
                }
            }
            Helper::Log("info", "Success", $res->message);
            return Helper::generalResponse(true, 'Success', $res->message);
        }catch(\Exception $e){
            Helper::Log('error','Hospital Portal Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }

    }
    public function list(Request $request){
       if (is_null($this->me->member_no) || is_null($this->me->card_number) || is_null($this->me->relationship)) {
           return Helper::generalResponse(false, 'Membership tidak ditemukan.', [], 400);
       }
        try {
            // $conn = DB::connection('stag_medika');
            $sql = "";
            $where = "";
            $cek = "SELECT
                        member_number,
                        card_number,
                        classification_member,
                        relationship
                    FROM
                        res_partner
                    WHERE
                        card_number = '" . $this->me->card_number . "'";
            $member = DB::select(DB::raw($cek));

            if ($member[0]->relationship == 'E') {
                $where .= "AND adm.member_number = '" . $this->me->member_no . "'";
            } else {
                $where .= "AND adm.card_number = '" . $this->me->card_number . "'";
            }

            //	$where .= "AND adm.card_number = '" . '0503980000515557' . "'";
            if (!is_null($request->query('id_admission'))) {
                $where .= "AND adm.id = '" . $request->query('id_admission') . "'";
            }
            $sql = "SELECT
                        adm.id,
                        adm.name,
                        gl.claim_number,
                        adm.letter_id,
                        adm.admission_date,
                        adm.state,
                        gl.service_type,
                        b.name as benefit,
                        bb.NAME as claim_type,
                        g.charge,
                        adm.claim_source,
                        g.approved_amount,
                        (select sum(fg.cover_amount) from final_gl fg where fg.letter_id= gl.id) as cover_amount,
                        g.real_cover_amount,
                        g.real_excess_amount,
                        cast(g.excess_amount as INT),
                        gl.amount_excess,
                        gl.amount_approved,
                        gl.concat_excess_comment as excess_description,
                        gl.claim_status,
                        gl.payment_date as service_date,
                        adm.notes
                    FROM
                        mobile_apps_admission adm
                    LEFT JOIN res_partner rp on
                        adm.card_number = rp.card_number
                    LEFT JOIN guarantee_letter gl on
                        gl.id = adm.letter_id
                    LEFT JOIN lateral (
                        SELECT
                            *
                        FROM
                            final_gl
                        WHERE
                            gl.id = final_gl.letter_id
                        LIMIT 1
                                ) g ON
                        gl.id = g.letter_id
                    LEFT JOIN benefit_master bb on
                        adm.benefit_master_id = bb.id
                    LEFT JOIN benefit_benefit b on
                        g.benefit_id = b.id
                    WHERE 1=1
                        $where
                        AND adm.claim_source = 'portal'
                    ORDER BY adm.id DESC";
            $data = DB::select(DB::raw($sql));
            if (!count($data)) {
                Helper::Log('error', 'Portal Not Found', []);
                return Helper::generalResponse(true, 'Portal Not Found', []);
            }
            $result = collect($data)->map(function($res){
                //get detail
                $detail = [];
                if(isset($res->letter_id) || !is_null($res->letter_id)){
                    $detail_claim = "SELECT
                                        l.claim_number,
                                        g.approved_amount as amount_approved,
                                        g.excess_amount,
                                        g.cover_amount as real_cover_amount,
                                        g.charge,
                                        b.name as benefit,
                                        b.description benefit_description
                                    FROM
                                        final_gl g
                                    LEFT JOIN benefit_benefit b on
                                        g.benefit_id = b.id
                                    LEFT JOIN guarantee_letter l on
                                        g.letter_id = l.id
                                    WHERE
                                        g.letter_id = '" . $res->letter_id . "'";
                    $detail = collect(DB::select(DB::raw($detail_claim)));
                }
                $sql_status = Notifikasi::where('id_admission', $res->id)->where('id_user',$this->me->id)->orderBy('created_at', 'ASC')->get();
                $status = collect($sql_status)->map(function($r){
                    try {
                        $status = [
                            'status'    => $r['label'],
                            'date'      => Carbon::parse($r['created_at'])->format('d-m-Y H:i')??'',
                        ];
                        return $status;
                    } catch (\Exception $e) {
                        return [];
                    }
                })->toArray();
                $claim_status = Library::mapStatus($res->claim_status);
                $res->claim_status = ($claim_status == '' || is_null($claim_status))?'Requested':$claim_status;
                $res->service_type = Library::serviceType($res->service_type);
                $res->status= $status;
                $res->attachment= [];
                
                $res->detail= $detail;
                try{
                    $res->admission_date = Carbon::createFromFormat('Y-m-d',$res->admission_date)->format('d-m-Y');
                    $res->service_date = Carbon::createFromFormat('Y-m-d',$res->service_date)->format('d-m-Y');
                }catch(Exception $e){
                    $res->admission_date = $res->admission_date??"";
                    $res->service_date = $res->service_date??"";
                }
                return $res;
            })->values()->toArray();
            return Helper::generalResponse(true, 'Success', $result);
        } catch (\Exception $e) {
            Helper::Log('error', 'Error Get Hospital Portal', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }

    }
    public function getClaimType(){
        try {
            $sql = "";
            $sql = "SELECT
                        lower(bm.name) as claim_type
                    FROM
                        benefit_master bm
                    GROUP BY
                        bm.name";
            $data = DB::select(DB::raw($sql));
            return Helper::generalResponse(true, 'Success', $data);
        } catch (\Exception $e) {
            Helper::Log('error', 'Error Get Claim Type', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
    public function detailAppointment(Request $request){
        if (is_null($this->me->member_no) || is_null($this->me->card_number) || is_null($this->me->relationship)) {
            return Helper::generalResponse(false, 'Membership tidak ditemukan.', [], 400);
        }
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  ['id_admission' => 'required'],  []);
        try {
            // $conn = DB::connection('stag_medika');
            $sql = "";
            $where = "";
            $cek = "SELECT
                        member_number,
                        card_number,
                        classification_member,
                        relationship
                    FROM
                        res_partner
                    WHERE
                        card_number = '" . $this->me->card_number . "'";
            $member = DB::select(DB::raw($cek));
            // if ($member[0]->relationship == 'E') {
            //     $where .= "AND adm.member_number = '" . $this->me->member_no . "'";
            // } else {
            //     $where .= "AND adm.card_number = '" . $this->me->card_number . "'";
            // }
            $sql = "SELECT
                        adm.id,
                        adm.name,
                        gl.claim_number,
                        adm.admission_date,
                        gl.service_type,
                        b.name as benefit,
                        bb.NAME as claim_type,
                        g.charge,
                        adm.claim_source,
                        g.approved_amount as amount_approved,
                        cast(g.excess_amount as INT),
                        gl.concat_excess_comment as excess_description,
                        gl.claim_status,
                        gl.payment_date as service_date,
                        adm.notes
                    FROM
                        mobile_apps_admission adm
                    LEFT JOIN res_partner rp on
                        adm.card_number = rp.card_number
                    LEFT JOIN guarantee_letter gl on
                        gl.id = adm.letter_id
                    LEFT JOIN final_gl g on
                        g.letter_id = gl.id
                    LEFT JOIN benefit_master bb on
                        adm.benefit_master_id = bb.id
                    LEFT JOIN benefit_benefit b on
                        g.benefit_id = b.id
                    WHERE 1=1
                        $where
                        AND adm.id = '" . $request->query('id_admission') . "'
                        AND adm.claim_source = 'portal'
                    ORDER BY adm.admission_date DESC";
            $data = DB::select(DB::raw($sql));
            if (!count($data)) {
                Helper::Log('error', 'Portal Not Found', []);
                return Helper::generalResponse(true, 'Portal Not Found', []);
            }
            $result = collect($data)->map(function($res){
                $sql_status = Notifikasi::where('id_admission', $res->id)->orderBy('created_at', 'ASC')->get();
                $status = collect($sql_status)->map(function($r){
                    try {
                        $status = [
                            'status'    => $r['label'],
                            'date'      => Carbon::parse($r['created_at'])->format('Y-m-d H:i')??'',
                        ];
                        return $status;
                    } catch (\Exception $e) {
                        return [];
                    }
                })->toArray();
                $res->claim_status = (Library::claimStatus($res->claim_status) == '')?'Requested':Library::claimStatus($res->claim_status);
                $res->service_date = $res->service_date ?? "";
                $res->service_type = Library::serviceType($res->service_type);
                $res->status= $status;
                return $res;
            })->values()->toArray();
            return Helper::generalResponse(true, 'Success', $result);
        } catch (\Exception $e) {
            report($e);
            Helper::Log('error', 'Error Get Detail Appointment', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
}
