<?php

namespace App\Http\Controllers;

use Helper;
use App\Models\Jitsi_log;
use App\Models\App_device;
use App\Models\App_version;
use Illuminate\Http\Request;
use App\Repository\FaspayManager;
use Illuminate\Support\Facades\DB;
use App\Services\Validator\ValidatorManager;
use App\Services\CloudStorage;

class ExternalController extends Controller
{
    public $REPO;
    public $conn;

    public function __construct()
    {
        $this->REPO         = new FaspayManager();
        if (config('services.medikaplaza.telemedicine_mode') == 'production') {
            $this->conn        = DB::connection('pgsql');
        } else {
            $this->conn        = DB::connection('stag_medika');
        }
    }
    public function fastpayHook(Request $request)
    {
        try {
            Helper::LogFaspay('info', 'faspay-hook', $request->all());
            $payment = $this->REPO->paymentNotification($request);
            return $payment;
        } catch (\Exception $e) {
            report($e);
            Helper::LogFaspay('error', 'Error Payment Notification Faspay', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }

    public function jitsiHook(Request $request)
    {
        try {
            Helper::Log('info', 'jitsi-hook', $request->all());

            $appNamespace = config('services.medikaplaza.jitsi') . '/';
            $roomName = str_replace($appNamespace, '', $request->get('fqn'));
            $status = $request->get('eventType');
            $req = $request->all();

            Jitsi_log::create([
                'request' => $req,
                'room_name' => $roomName,
                'status' => $status,
            ]);

            // handle record upload
            if ($status == 'RECORDING_UPLOADED') {
                // try parse response
                try {
                    $url = $req['data']['preAuthenticatedLink'];
                    $q = sprintf("SELECT
                            COUNT(*) c
                        FROM jitsi_log
                        WHERE status = 'RECORDING_UPLOADED'
                        AND request->'data'->>'preAuthenticatedLink' = '%s'
                    ", $roomName);
                    $checkReceived = DB::select($q)[0]->c;
                    if ($checkReceived <= 1) {
                        // not yet stored
                        CloudStorage::fetchAndStore($url);
                    }
                } catch (\Exception $e) {
                    report($e);
                }
            }

            // send brand override
            $settings = collect($this->conn->table('app_setting')->get())->pluck('value', 'key');

            $result = [];
            if (isset($settings['TELMED_IMAGE_BACKGROUND'])) {
                $result['backgroundImageUrl'] = $settings['TELMED_IMAGE_BACKGROUND'];
            }
            if (isset($settings['TELMED_IMAGE_LOGO'])) {
                $result['logoImageUrl'] = $settings['TELMED_IMAGE_LOGO'];
            }
            if (isset($settings['TELMED_VIRTUAL_BACKGROUND'])) {
                $result['virtualBackgrounds'] = $settings['TELMED_VIRTUAL_BACKGROUND'];
            }

            /*
            $result = [
                // "backgroundColor" => "#FFF",
                "backgroundImageUrl" => "https://medikaplaza.com/wp-content/uploads/2021/03/Foto-visi-misi.jpg",
                // "didPageUrl" => "https://mycompany.com/dids",
                // "inviteDomain" => "https://mycompany.com/invite",
                // "logoClickUrl" => "https://mycompany.com",
                "logoImageUrl" => "https://medikaplaza.com/wp-content/uploads/2021/05/mp-favicon.png",
                "avatarBackgrounds" => ["#12A378", "linear-gradient(125.83deg, #000 0%, #FFF 99.09%)"],
                // "premeetingBackground" => "url(https://mycompany.com/images/premeetingBackground.png)",
                "virtualBackgrounds" => ["https://mp-onestaging-mobile.medikaplaza.com/bg.jpg"],
            ];
            */

            return $result;
        } catch (\Exception $e) {
            report($e);
            Helper::Log('error', 'Error Hook Jitsi', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
}
