<?php

namespace App\Http\Controllers\Ecard;

use Helper;
use Imagick;
use Exception;
use Carbon\Carbon;
use GuzzleHttp\Client;
use App\Mail\SendEcard;
use Spatie\PdfToImage\Pdf;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Storage;
use App\Services\Validator\ValidatorManagerInterface;

class EcardController extends Controller
{
    public $me;
    public function __construct()
    {
        $this->me          = auth()->user();
    }
    public function eCard(Request $request)
    {
        try{
            app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  ['card_number' => 'required'],  []);
            $card_number = $request->card_number;
            //$card_number = "0500366890009930";
            $check = Hash::check($request->password, $this->me->password);
            if (!$check) {
                return Helper::generalResponse(false, 'Password don\'t match.', [], 400);
            }
            $filename = $card_number.'.jpg';
            
            $is_exist_ecard = Helper::isExistImg('ecard', $filename);
            if($is_exist_ecard){
                try{
                    $time = Storage::lastModified('ecard/'.$filename);
                    $now   =  Carbon::now()->toDateTimeString();
                    $time_card = Carbon::createFromTimestamp($time)->addMinutes(10)->toDateTimeString();
                    if($now > $time_card){
                        $del = Storage::delete('ecard/'.$filename);
                        $ecardMPOne  = self::getEcardMpOne($request);
                        if(!$ecardMPOne){
                            return Helper::generalResponse(false, 'Membership tidak ditemukan.', [], 400);
                        }
                        Helper::Log("info", "Success", $ecardMPOne);
                        return Helper::generalResponse(true, 'Success', $ecardMPOne);
                    }else{
                        $image =  url('ecard/'.$filename);
                        $result = [
                            'ecard'          => $image,
                            'send_email'    => false
                        ];
                        if (!is_null($request->send_email) && $request->send_email == 'true' ) {
                            self::sendEmail($result);
                            $result['send_email'] = true;
                        }
                        Helper::Log("info", "Success", $result);
                        return Helper::generalResponse(true, 'Success', $result);
                    }
                }catch(\Exception $e){
                    report($e);
                }
                
            }else{
                try{
                    $ecardMPOne  = self::getEcardMpOne($request);
                    if(!$ecardMPOne){
                        return Helper::generalResponse(false, 'Membership tidak ditemukan.', [], 400);
                    }
                    Helper::Log("info", "Success", $ecardMPOne);
                    return Helper::generalResponse(true, 'Success', $ecardMPOne);
                }catch(\Exception $e){
                    report($e);
                }
            }
        }catch(\Exception $e){
            report($e);
            Helper::Log('error','Get Ecard Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }

    }
    public function getEcardMpOne($request){
        $url = config('services.medikaplaza.ecard');
        try{
            $card_number = $request->card_number;
            $payload = sprintf('{
            "params": { 
                "card_number": "%s"
                }
            }', $card_number);
                    $response = Http::withBody(
            $payload, 'text/plain'
            )->post($url);
                $res = json_decode($response);
            
            if (! isset($res->data)) {
                throw new \Exception($res->message);
            }

            $pdf = base64_decode($res->data->binary);
            $doc_preview = new Imagick();
            $doc_preview->setResolution(600,600);
            $doc_preview->readImageBlob($pdf);
            $total = $doc_preview->getIteratorIndex();
            $doc_preview->setIteratorIndex(0);
            $doc_preview->writeImage(storage_path('app/ecard/').$card_number.'.jpg');
            
            $doc_preview->clear();
            $doc_preview->destroy();
            
            $image =  url('ecard/'.$card_number.'.jpg');
            $result = [
                'ecard'          => $image,
                'send_email'    => false
            ];
            
            if (!is_null($request->send_email) && $request->send_email == 'true' ) {
                
                self::sendEmail($result);
                $result['send_email'] = true;
            }
            return $result;
        }catch(Exception $e){
            report($e);
        }
    }
    public function listEcard(){
        try{
             //cek employee
             $is_employee = "";
             if(is_null($this->me->relationship) || is_null($this->me->card_number)|| is_null($this->me->member_no)){
                return Helper::generalResponse(false,  "Member not Verified", [], 500);
             }
             if ($this->me->relationship == 'E') {
                 $is_employee = "member_number = '" . $this->me->member_no . "'";
             } else {
                 $is_employee = "card_number = '" . $this->me->card_number . "'";
             }
            $cek = "SELECT
                        name,
                        card_number
                    FROM
                        res_partner
                    WHERE
                        $is_employee
                    ORDER BY suffix_id ASC";
            $member = DB::select(DB::raw($cek));
            return Helper::generalResponse(true, 'Success', $member);

        }catch(\Exception $e){
            Helper::Log('error','Get list Ecard Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }
    }

    // deprecated, not used
    public function downloadEcard(Request $request){
        try {
            app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  ['card_number' => 'required'],  []);
            // $card_number = $request->card_number;
            $card_number = "0500366890009930";
            $filename = $card_number.'.jpg';
            $is_exist_ecard = Helper::isExistImg('ecard', $filename);
            if($is_exist_ecard){
                $check = Hash::check($request->password, $this->me->password);
                if (!$check) {
                    return Helper::generalResponse(false, 'Password don\'t match.', [], 400);
                }
                $filepath = storage_path('app/ecard/').$filename;
                return \Response::download($filepath); 
            }else{
                Helper::Log('error', 'Download Ecard Failed Storage not found', []);
                return Helper::generalResponse(false, 'Download Ecard Failed Storage not found', []);
            }
        } catch (\Exception $e) {
            Helper::Log('error', 'Download Ecard Failed', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage());
        } 
    }
    public function sendEmail($data){
        try{
            Mail::to($this->me->email)->send(new SendEcard($this->me, $data));
            if (Mail::failures()) {
                Helper::Log("warning", "Failed Send Email Ecard", ["to" => $this->me->email, "message" => "Send email failed"]);
                return Helper::generalResponse(false, "Failed send to ".$this->me->email, []);
            }
            Helper::Log("info","Send Email Ecard Success to ".$this->me->email);
            return Helper::generalResponse(true, "Successfully send to ".$this->me->email, []);
        }catch(\Exception $e){
            report($e);
            Helper::Log('error','Download Ecard Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }
       
    }
}
