<?php

namespace App\Http\Controllers;

use Helper;
use App\Models\MPOne_log;
use App\Models\Trx_history_telmed;
use Illuminate\Support\Facades\Http;
use Illuminate\Http\Request;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use App\Services\Validator\ValidatorManagerInterface;
use Illuminate\Routing\Controller as BaseController;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    public function home() {
        $result = 'hit';
        return Helper::generalResponse(true, 'Success', $result);
    }

    public function generateSignature(Request $request)
    {
        $billNo = $request->get('bill_no');
        $signature = \App\Services\Faspay::generateSignature($billNo);

        $result = [
            'bill_no' => $billNo,
            'signature' => $signature,
        ];

        return Helper::generalResponse(true, 'Success', $result);
    }

    public function serveImg(Request $request)
    {
        $pathToFile = public_path('assets/img/'.$request->get('file'));
        return response()->file($pathToFile);
    }

    public function uploadTest(Request $request)
    {
        $rule = [
            'attachment' => 'nullable|array',
            'attachment.*' => 'nullable|file',
        ];
        $this->validate($request, $rule);
        // app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);

        return response()->json('');
    }

    public function logMpone(Request $request)
    {
        $rows = MPOne_log::latest();

        if ($request->get('trx')) {
            $rows = $rows->where('trx_no', $request->get('trx'));
        }
        
        $rows = $rows->get();

        return view('log', compact('rows'));
    }

    public function logMponeTrigger(Request $request)
    {
        $c = MPOne_log::find($request->get('id'));
        if (! is_null($c)) {
            $url = $c->endpoint;
            $payload = json_encode($c->request);
            Helper::Log("info", "Trigger MPOne - Request", [$payload]);
            $response = Http::withBody(
                        $payload, 'application/json'
                        )->post($url);
            $res = json_decode($response);
            if (!isset($res) || is_null($res)) {
                throw new \Exception("Trigger MPOne - Failed");
            }
            Helper::Log("info", "Trigger MPOne - Response", [$res]);

            $isSuccess = null;
            if (strpos($response, '"00"') !== false) {
                $isSuccess = true;
            }

            MPOne_log::create([
                'trx_no' => $c->trx_no,
                'endpoint' => $url,
                'response' => $res,
                'request' => $c->request,
                'is_success' => $isSuccess,
            ]);
        }

        return redirect()->to(
            url('mpone-log') . '?' . http_build_query(['trx' => $request->get('trx')])
        );
    }

    public function logMponeDecline(Request $request)
    {
        $c = Trx_history_telmed::where('trx_no', $request->get('trx'))->first();
        if (! is_null($c)) {
            $repo = new \App\Repository\MPOneManager();
            $repo->declineGlV2($c);
        }

        return redirect()->to(
            url('mpone-log') . '?' . http_build_query(['trx' => $request->get('trx')])
        );
    }
}
