<?php

namespace App\Http\Controllers\Claim;

use Helper;
use Library;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Services\Validator\ValidatorManagerInterface;

class ClaimController extends Controller
{
    public $me;
    public function __construct()
    {
        $this->me          = auth()->user();
    }
    public function claim(Request $request)
    {
        if (is_null($this->me->member_no) || is_null($this->me->card_number) || is_null($this->me->relationship)) {
            return Helper::generalResponse(false, 'Membership tidak ditemukan.', [], 400);
        }

        try {
            $cek = "SELECT
                        member_number,
                        card_number,
                        classification_member,
                        relationship
                    FROM
                        res_partner
                    WHERE
                        card_number = '" . $this->me->card_number . "'";
            $member = DB::select(DB::raw($cek));
            if (empty($member)) {
                //add fallback to check if changed
                $cek_change = "SELECT
                        member_number,
                        card_number,
                        classification_member,
                        relationship
                    FROM res_partner
                    WHERE member_number = '" . $this->me->member_no . "' AND relationship = '" . $this->me->relationship . "'";
                $has_new = DB::select(DB::raw($cek_change));
                if (empty($has_new)) {
                    // dont have new card number
                    return Helper::generalResponse(false, 'Membership tidak ditemukan.', [], 400);
                }

                //update new card number and member type user
                $user = $this->me;
                $user->card_number = $has_new[0]->card_number;
                $user->member_type = $has_new[0]->classification_member;
                $user->save();

                //set current user prop
                $this->me->card_number = $user->card_number;
            }

            //hardcode find by card number, either employee or other (spouse, children)
            //cek employee
            $is_employee = "";
            if ($member[0]->relationship == 'E') {
                $is_employee = "AND rp.member_number = '" . $this->me->member_no . "'";
            } else {
                $is_employee = "AND rp.card_number = '" . $this->me->card_number . "'";
            }

            $sql = "SELECT
                        rp.name,
                        cp.name as company,
                        rp.classification_member,
                        rp.policy_status,
                        rp.client_branch_id,
                        rp.division,
                        rp.division_id,
                        rp.member_client_id,
                        rp.gender,
                        rp.card_number,
                        rp.nik,
                        rp.birth_date,
                        rp.effective_date_member,
                        rp.end_policy_date,
                        rp.join_date,
                        rp.start_date,
                        rp.end_date,
                        rp.marital_status,
                        rp.relationship,
                        rp.program_id,
                        cpp.name program_plan,
                        rp.program_plan_id
                    FROM
                        res_partner rp
                    LEFT JOIN client_program_plan cpp ON
	                    cpp.id = rp.program_plan_id
                    LEFT JOIN client_program cp ON
	                    cp.id = rp.program_id
                    WHERE
                        rp.is_company = false
                        $is_employee
                        ORDER BY suffix_id ASC";
            $data = DB::select(DB::raw($sql));
            foreach ($data as $val) {
                $val->relation_ship_label = Library::statusRelationship($val->relationship);
                $val->gender_label = Library::statusGender($val->gender);
                $val->status_member = Library::statusMember($val->classification_member);
                $end_date           = Carbon::parse($val->end_date);
                $val->masa_berlaku  = $end_date->isoFormat('MMM YYYY');

                $val->policy_status = Library::policyStatus($val->policy_status);
                $val->badge_no = $val->nik ?? '-';

                try {
                    $val->join_date = Carbon::parse($val->join_date)->format('d-m-Y');
                    $val->end_policy_date = Carbon::parse($val->end_policy_date)->format('d-m-Y');
                    $val->effective_date  = Carbon::parse($val->effective_date_member)->format('d-m-Y') ?? "-";
                    $val->start_date  = Carbon::parse($val->effective_date_member)->format('d-m-Y') ?? "-";
                    $val->end_date  = Carbon::parse($val->end_policy_date)->format('d-m-Y') ?? "-";
                } catch (\Exception $e) {
                    $val->join_date = $val->join_date;
                    $val->end_policy_date = $val->end_policy_date;
                    $val->end_date = $val->end_policy_date;
                }
            }
            return Helper::generalResponse(true, 'Success', $data);
        } catch (\Exception $e) {
            Helper::Log('error', 'Error Get Claim List', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
    public function claimHistory(Request $request)
    {
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  ['card_number' => 'required','admission_date' => 'date_format:d-m-Y'],  []);
        try {
            $cek = "SELECT
                        member_number,
                        card_number,
                        classification_member,
                        relationship
                    FROM
                        res_partner
                    WHERE
                        card_number = '" . $request->query('card_number') . "'";
            $member = DB::select(DB::raw($cek));
            if (is_null($member) || empty($member)) {
                Helper::Log('error', 'Membership tidak ditemukan', []);
                return Helper::generalResponse(false, 'Membership tidak ditemukan.', [], 400);
            }
            $sql = "";
            $admission_date = "";
            if (!is_null($request->query('card_number'))) {
                $card_number = "and rp.card_number = '" . $request->query('card_number') . "'";
            }
            if (!is_null($request->query('admission_date'))) {
                $from = Carbon::createFromFormat('d-m-Y',$request->query('admission_date'))->format('m-d-Y');
                $to = Carbon::createFromFormat('d-m-Y',$request->query('admission_date_end'))->format('m-d-Y') ?? Carbon::createFromFormat('d-m-Y',$request->query('admission_date'))->format('m-d-Y');
                $admission_date = "and DATE(l.admission_date) >= '" . $from . "' AND DATE(l.admission_date) <= '" . $to . "'";
            }
            $card_number = $card_number ?? '';
            $sql = "SELECT
                        l.NAME,
                        l.member_number,
                        rp.card_number,
                        l.claim_number,
                        l.admission_date,
                        l.service_type,
                        l.claim_status,
                        l.provider_id,
                        p.NAME provider,
                        l.payment_date as service_date,
                        fg.approved_amount,
                        (
                        SELECT
                            sum(fg.charge)
                        FROM
                            final_gl fg
                        WHERE
                            fg.letter_id = l.id) as charge,
                        l.amount_excess,
                        l.amount_approved,
                        (select sum(fg.cover_amount) from final_gl fg where fg.letter_id= l.id) as cover_amount,
                        fg.letter_id,
                        fg.excess_remarks,
                        fg.real_cover_amount,
                        fg.real_excess_amount,
                        cast(fg.excess_amount as INT),
                        b.NAME as benefit,
                        (
                            SELECT
                                string_agg (name,', ') as name
                            FROM
                                diagnosis_diagnosis dd2
                            WHERE
                                dd2.id in(l.diagnosa1_id, l.diagnosa2_id, l.diagnosa3_id, l.diagnosa4_id)) as benefit_description,
                        l.concat_excess_comment as excess_description
                    FROM
                        guarantee_letter l
                    LEFT JOIN lateral (
                        SELECT
                            *
                        FROM
                            final_gl
                        WHERE
                            l.id = final_gl.letter_id
                        LIMIT 1
                                    ) fg ON
                        l.id = fg.letter_id
                    LEFT JOIN benefit_master b ON
                        l.benefit_master_id = b.id
                    LEFT JOIN res_partner p ON
                        l.provider_id = p.id
                    LEFT JOIN res_partner rp ON
                        l.member_id = rp.id
                    WHERE
                        1 = 1
                        AND l.claim_number in (
                        SELECT
                            l.claim_number
                        FROM
                            guarantee_letter l
                        LEFT JOIN res_partner rp ON
                            l.member_id = rp.id
                        WHERE
                            rp.member_number = '" . $this->me->member_no . "'
                            $card_number
                            $admission_date
                        GROUP BY
                            l.claim_number)
                        ORDER BY 
                            l.admission_date DESC";
            $data = DB::select(DB::raw($sql));
            $is_valid = count($data) ? 'valid' : 'notvalid';
            if ($is_valid == 'notvalid') {
                Helper::Log('error', 'Error Get Claim History notvalid', []);
                return Helper::generalResponse(true, 'Error Get Claim History notvalid', []);
            }
            foreach ($data as $val) {
                $val->claim_status = Library::claimStatus($val->claim_status);
                $val->service_type = Library::serviceType($val->service_type);

                try {
                    $val->admission_date = Carbon::createFromFormat('Y-m-d',$val->admission_date)->format('d-m-Y');
                    $val->service_date = Carbon::createFromFormat('Y-m-d',$val->service_date)->format('d-m-Y');
                    if ($val->claim_status == 'import'){ 
                        $val->claim_status = '';
                        $val->service_date = '';
                    } 
                } catch (\Exception $e) {
                    $val->admission_date = $val->admission_date??"";
                    $val->service_date = $val->service_date ?? "";
                }
            }
            return Helper::generalResponse(true, 'Success', $data);
        } catch (\Exception $e) {
            Helper::Log('error', 'Error Get Claim History List', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
    public function getAdmisionDate(Request $request)
    {
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  ['card_number' => 'required'],  []);
        try {
            $cek = "SELECT
                        member_number,
                        card_number,
                        classification_member,
                        relationship
                    FROM
                        res_partner
                    WHERE
                        card_number = '" . $request->query('card_number') . "'";
            $member = DB::select(DB::raw($cek));
            if (is_null($member) || empty($member)) {
                Helper::Log('error', 'Membership tidak ditemukan', []);
                return Helper::generalResponse(false, 'Membership tidak ditemukan.', [], 400);
            }
            $sql = "";
            if (!is_null($request->query('card_number'))) {
                $card_number = "and rp.card_number = '" . $request->query('card_number') . "'";
            }
            $card_number = $card_number ?? '';
            $sql = "SELECT
                        l.admission_date
                    FROM
                        guarantee_letter l
                    LEFT JOIN lateral (
                        SELECT
                            *
                        FROM
                            final_gl
                        WHERE
                            l.id = final_gl.letter_id
                        LIMIT 1
                                    ) fg ON
                        l.id = fg.letter_id
                    LEFT JOIN benefit_master b ON
                        l.benefit_master_id = b.id
                    LEFT JOIN res_partner p ON
                        l.provider_id = p.id
                    LEFT JOIN res_partner rp ON
                        l.member_id = rp.id
                    WHERE
                        1 = 1
                        AND l.claim_number in (
                        SELECT
                            l.claim_number
                        FROM
                            guarantee_letter l
                        LEFT JOIN res_partner rp ON
                            l.member_id = rp.id
                        WHERE
                            rp.member_number = '" . $this->me->member_no . "'
                            $card_number
                        GROUP BY
                        l.claim_number,
                        l.admission_date)";
            $data = DB::select(DB::raw($sql));
            $is_valid = count($data) ? 'valid' : 'notvalid';
            if ($is_valid == 'notvalid') {
                Helper::Log('error', 'Error Get Date Admision Claim History notvalid', []);
                return Helper::generalResponse(true, 'Error Get Date Admision Claim History notvalid', []);
            }

            $data = collect($data)->map(function($r) {
                try {
                    return Carbon::createFromFormat('Y-m-d',$r->admission_date)->format('d-m-Y');
                } catch (\Exception $e) {
                    return null;
                }
                })->filter(function($r) {
                    return $r != null;
                })->toArray();
            return Helper::generalResponse(true, 'Success', $data);
        } catch (\Exception $e) {
            Helper::Log('error', 'Error Get Date Admision Claim History List', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }

    public function detailClaim(Request $request)
    {
        try {
            $cek = "SELECT
                        member_number
                    FROM
                        guarantee_letter
                    WHERE
                        REPLACE(member_number,'', member_number) = '" . $this->me->member_no . "'";
            $member = DB::select(DB::raw($cek));
            if (is_null($member) || empty($member)) {
                return Helper::generalResponse(false, 'Membership tidak ditemukan.', [], 400);
            }
            app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  ['letter_id' => 'required'],  []);
            $sql = "";
            $sql = "SELECT
                        l.claim_number,
                        g.approved_amount as amount_approved,
                        g.real_excess_amount as excess_amount,
                        g.real_cover_amount,
                        g.charge,
                        b.name as benefit,
                        b.description benefit_description
                from
                    final_gl g
                left join benefit_benefit b on
                    g.benefit_id = b.id
                left join guarantee_letter l on
                    g.letter_id = l.id
                where
                    g.letter_id = '" . $request->query('letter_id') . "'";
            $data = DB::select(DB::raw($sql));
            $is_valid = count($data) ? 'valid' : 'notvalid';
            if ($is_valid == 'notvalid') {
                Helper::Log('error', 'Error Get Claim Detail notvalid', []);
                return Helper::generalResponse(true, 'Error Get Claim Detail notvalid', []);
            }

	    $data = collect($data)->map(function($i) {
		    $i->claim_number = (string) $i->claim_number;
		    $i->amount_approved = (string) ($i->amount_approved ?? 0);
		    $i->excess_amount = (string) ($i->excess_amount ?? 0);
		    $i->real_cover_amount = (string) ($i->real_cover_amount ?? 0);
		    $i->charge = (string) ($i->charge ?? 0);
		    $i->benefit = (string) $i->benefit;
		    $i->benefit_description = (string) $i->benefit_description;
                return $i;
            })->toArray();

            return Helper::generalResponse(true, 'Success', $data);
        } catch (\Exception $e) {
            Helper::Log('error', 'Error Get Claim Detail List', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
    public function claimBenefit(Request $request)
    {
        app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  ['card_number' => 'required'],  []);
        try {
            $cek = "SELECT
                    id,
                    member_number,
                    card_number,
                    classification_member,
                    relationship
                FROM
                    res_partner
                WHERE
                    card_number = '" . $request->query('card_number') . "'";
            $member = DB::select(DB::raw($cek));
            if (is_null($member) || empty($member)) {
                return Helper::generalResponse(false, 'Membership tidak ditemukan.', [], 400);
            }
            $memberId = $member[0]->id;
            /*
            $sql = "";
            $sql = "SELECT
                        rp.name,
                        rp.card_number,
                        rp.member_number,
                        rp.relationship,
                        charge.used,
                        charge.annual_limit,
                        b.name as benefit,
                        bp.id as benefit_parent_id,
                        bp.name as benefit_parent
                    -- FROM
                    --     res_partner rp
                    -- RIGHT JOIN (
                    --     SELECT
                    --         gl.member_id member_id,
                    --         fg.benefit_id,
                            -- MAX(pph.annual_limit) annual_limit,
                        --     SUM(fg.charge) used
                        -- FROM
                        --     guarantee_letter gl
                        -- LEFT JOIN final_gl fg ON
                        --     fg.letter_id = gl.id
                        -- LEFT JOIN header_detail hd ON
                            -- fg.detail_id = hd.id
                        -- LEFT JOIN program_plan_header pph ON
                            -- hd.header_id = pph.id
                    --     WHERE
                    --         1 = 1
                    --         and fg.benefit_id is not null
                    --         and fg.detail_id is not null
                    --         and member_id = '".$member[0]->id."'
                    --     GROUP BY
                    --         fg.benefit_id,
                    --         member_id
                    -- ) charge on
                    --     rp.id = charge.member_id
                    -- left join benefit_benefit b on
                    --     charge.benefit_id = b.id
                    -- left join benefit_master bp on
                        b.master_id = bp.id";
            $data = DB::select(DB::raw($sql));
            */

            // get info benefit w limit
            $meta_q = "SELECT
                rp.name,
                rp.card_number,
                rp.member_number,
                pph.id program_plan_id,
                rp.relationship,
                pph.annual_limit,
                pph.benefit_category_id benefit_parent_id,
		pph.limit_selection,
                bp.name benefit_parent
            FROM res_partner rp
            LEFT JOIN client_program_plan cpp ON rp.program_plan_id = cpp.id
            LEFT JOIN LATERAL (
                SELECT SUM(pph2.annual_limit) annual_limit, pph2.benefit_category_id, pph2.plan_id, pph2.id, INITCAP(MAX(pph2.limit_selection)) limit_selection
                FROM program_plan_header pph2
                WHERE pph2.plan_id = cpp.id
                GROUP BY pph2.benefit_category_id, pph2.plan_id, pph2.id
            ) pph ON cpp.id = pph.plan_id
            LEFT JOIN benefit_master bp ON pph.benefit_category_id = bp.id
            WHERE rp.id = '%s'";
            $meta = collect(DB::select(sprintf($meta_q, $memberId)));

            if (!count($meta)) {
                Helper::Log('error', 'Error Get Claim Benefit notvalid', []);
                return Helper::generalResponse(true, 'Error Get Claim Benefit notvalid', []);
            }

            // get benefit details
            $items_q = "SELECT
                bp.id as benefit_parent_id,
                b.name as benefit,
                b.id as benefit_id
            FROM benefit_benefit b
            LEFT JOIN benefit_master bp ON b.master_id = bp.id
            WHERE b.id IN (
                SELECT bb.id
                FROM res_partner rp
                LEFT JOIN client_program_plan cpp ON rp.program_plan_id = cpp.id
                LEFT JOIN program_plan_header pph ON cpp.id = pph.plan_id
                LEFT JOIN header_detail hd ON pph.id = hd.header_id
                LEFT JOIN benefit_benefit bb ON hd.benefit_id = bb.id
                WHERE rp.id = '%s'
                GROUP BY bb.id
            )
            ORDER BY b.name ASC";
            $items = collect(DB::select(sprintf($items_q, $memberId)));

            $cek_family = "SELECT
                                pph.limit_selection,
                                pph.id as pph_id
                            FROM
                                program_plan_header pph
                            LEFT JOIN benefit_master bm on
                                pph.benefit_category_id = bm.id
                            where
                                pph.id IN(select
                                pph.id
                            from
                                guarantee_letter gl
                            LEFT JOIN final_gl fg on
                                fg.letter_id = gl.id
                            LEFT JOIN res_partner rp on
                                rp.id = gl.member_id
                            LEFT JOIN client_program_plan cpp on
                                rp.program_plan_id = cpp.id
                            LEFT JOIN program_plan_header pph on
                                cpp.id = pph.plan_id
                            LEFT JOIN header_detail hd on
                                pph.id = hd.header_id
                            LEFT JOIN benefit_benefit b on
                                fg.benefit_id = b.id
                                and hd.benefit_id = b.id
                            where
                                b.master_id is not null
                                AND rp.member_number = '" . $this->me->member_no . "'
                                and DATE(gl.admission_date)>=rp.start_date
                                and DATE(gl.admission_date)<=rp.end_date
                                and gl.claim_status not in ('import', 'open')
                            group by
                                pph.id) ";
            $is_family = DB::select(DB::raw($cek_family));
            if (!empty($is_family)) {
                if ($is_family[0]->limit_selection == 'family') {
                    $family = "AND rp.member_number = '" . $this->me->member_no . "'";
                } else {
                    $family = "AND member_id = '%s'";
                }
            } else {
                $family = "AND member_id = '%s'";
            }

            $used_q = "SELECT
                b.master_id benefit_parent_id,
                SUM(fg.cover_amount) used
            FROM guarantee_letter gl
            LEFT JOIN final_gl fg ON 
                fg.letter_id = gl.id
            LEFT JOIN res_partner rp ON
                rp.id = gl.member_id
            LEFT JOIN client_program_plan cpp ON
                rp.program_plan_id = cpp.id
            LEFT JOIN program_plan_header pph ON
                cpp.id = pph.plan_id
            LEFT JOIN header_detail hd ON
                pph.id = hd.header_id
            LEFT JOIN benefit_benefit b ON
                fg.benefit_id = b.id AND
                hd.benefit_id = b.id
            WHERE b.master_id IS NOT NULL $family  
            AND DATE(gl.admission_date)>=rp.start_date
	        AND DATE(gl.admission_date)<=rp.end_date 
            AND gl.claim_status not in ('import', 'open')
            GROUP BY b.master_id";
            $used = collect(DB::select(sprintf($used_q, $memberId)));

            $data = $meta->groupBy('program_plan_id')->map(function ($i, $k) use ($items, $used) {
                $row = $i->first();

                $b = [];
                $rowItem = $items->where('benefit_parent_id', $row->benefit_parent_id);
                foreach ($rowItem as $j) {
                    $b[] = str_replace($row->benefit_parent . ' - ', '', $j->benefit);
                }
                $used = $used->where('benefit_parent_id', $row->benefit_parent_id)->first();
                $row->used = $used ? ($used->used??'0') : '0';
                $row->benefit = $b;
                $row->relation_ship_label = Library::statusRelationship($row->relationship);
                $row->limit_available = $row->annual_limit == -1 ? 'As Charges' : (string) ($row->annual_limit - $row->used);

                return $row;
            })->values()->toArray();

            return Helper::generalResponse(true, 'Success', $data);
        } catch (\Exception $e) {
            Helper::Log('error', 'Error Get Claim Benefit List', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
}
