<?php

namespace App\Http\Controllers\BukuSaku;

use Helper;
use Imagick;
use Exception;
use Throwable;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Storage;
use App\Services\Validator\ValidatorManagerInterface;

class BukuSakuController extends Controller
{
    public $me;
    public function __construct()
    {
        $this->me          = auth()->user();
    }
    public function getBukuSakuMpOne(Request $request){
        try{
            app(ValidatorManagerInterface::class)->validateRequest(__FUNCTION__, $request,  ['card_number' => 'required'],  []);
            $url = config('services.medikaplaza.buku-saku');

            $card_number = $request->card_number;
            $payload = sprintf('{
                "params": { 
                    "card_number": "%s"
                    }
                }', $card_number); 
            $response = Http::withBody(
                    $payload, 'text/plain'
                    )->post($url);
            $res = json_decode($response);

            if (is_null($res)) {
                Helper::Log("error", "Error get buku saku: not found");
                throw new \Exception("Error get buku saku: not found");
            }

            if (! isset($res->data)) {
                Helper::Log("error", "Error get buku saku", $res->message);
                throw new \Exception($res->message);
            }

            $pdf = base64_decode($res->data->binary);
            $filename = $card_number.'.pdf';
            $store = Storage::disk('buku-saku')->put($filename,base64_decode($pdf));
            
            $file =  url('buku-saku/'.$card_number.'.pdf');
            $result = [
                'buku-saku'     => $file,
            ];
            
            Helper::Log("info", "Success", $result);
            return Helper::generalResponse(true, 'Success', $result);
        }catch(Exception $e){
            Helper::Log('error','Get Buku Saku Failed', $e->getMessage());
            return Helper::generalResponse(false,  $e->getMessage(), [], 500);
        }
        
    }
}
