<?php

namespace App\Http\Controllers\Blog;

use Helper;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class BlogController extends Controller
{
    public $me;
    public $conn;
    public $base_url;
    public function __construct()
    {
        $this->me          = auth()->user();
        $this->conn        = DB::connection('prod_promotion');
        $this->base_url     = config('services.medikaplaza.promotion');
    }
    public function blog(Request $request)
    {
        $base_url = config('services.medikaplaza.webfront');

        try {
            $sql = "";
            $where = "";
            if (!is_null($request->query('name'))) {
                $filter = $request->query('name');
                $where = "AND (bp.name ILIKE '%".$filter."%' OR bp.content ILIKE '%".$filter."%')";
            }
            if (!is_null($request->query('id_category'))) {
                $where .= "AND bt.id = '" . $request->query('id_category') . "'";
            }
            $sql = "SELECT
                        bp.id,
                        bp.name as title,
                        bp.subtitle,
                        bt.id as id_category,
                        bt.name as category,
                        bp.cover_properties as image,
                        bp.content,
                        bp.is_published,
                        bp.post_date,
                        bp.published_date
                    FROM
                        blog_post bp
                    LEFT JOIN blog_post_blog_tag_rel tr on 
                    	bp.id = tr.blog_post_id 
                    LEFT JOIN blog_tag bt on 
                    	bt.id = tr.blog_tag_id 
                    WHERE
                        is_published = true
                        $where
		    ORDER BY post_date DESC";
            $data = $this->conn->select(DB::raw($sql));
            foreach ($data as $val) {
                $bg_image = json_decode($val->image, true);
                $img_path = $bg_image['background-image'];
                $img_path = ltrim($img_path, 'url(/');
                $img_path = rtrim($img_path, ')');

		try {
			//$d = Carbon::createFromFormat('Y-m-d H:i:s',$val->post_date);
			$d = Carbon::parse($val->post_date);
			$val->post_date = $d->format('Y-m-d');
		} catch (\Exception $e) {
			//report($e);
			Helper::Log('error', 'Error Parse Blog Post Date', ['d' => $val->post_date, 'm' => $e->getMessage()] );
			//$val->post_date = Carbon::now()->format('Y-m-d');
		}

		$url = sprintf('%s/%s', $this->base_url, $img_path);
		//$url = sprintf('%s/web/image?model=blog.post&id=%s&field=image_upload', $this->base_url, $val->id);
                $val->image = $url;
                $val->content = strip_tags($val->content);
            }
            return Helper::generalResponse(true, 'Success', $data);
        } catch (\Exception $e) {
            Helper::Log('error', 'Error Get Blog List', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
    public function blogCategory()
    {
        try {
            $sql = "";
            $sql = "SELECT
                        bt.id as id_category,
	                    bt.name as category
                    FROM
                        blog_post bp
                    LEFT JOIN blog_post_blog_tag_rel tr on 
                    	bp.id = tr.blog_post_id 
                    LEFT JOIN blog_tag bt on 
                    	bt.id = tr.blog_tag_id 
                    WHERE
                        is_published = true
                        AND bt.id IS NOT NULL
                    GROUP BY
                        bt.id";
            $data = $this->conn->select(DB::raw($sql));
            return Helper::generalResponse(true, 'Success', $data);
        } catch (\Exception $e) {
            Helper::Log('error', 'Error Get Blog Category', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
    public function blogDev(Request $request)
    {
        $base_url = config('services.medikaplaza.webfront');

        try {
            $sql = "";
            $sql = "SELECT
                        bp.cover_properties as image
                    FROM
                        blog_post bp
                    WHERE
                        is_published = true";
            $data = $this->conn->select(DB::raw($sql));
            foreach ($data as $val) {
                $bg_image = json_decode($val->image, true);
                $img_path = $bg_image['background-image'];
                $img_path = ltrim($img_path, 'url(/');
                $img_path = rtrim($img_path, ')');

                $url = sprintf('%s/%s', $base_url, $img_path);
                $val->image = $url;
            }
            return Helper::generalResponse(true, 'Success', $data);
        } catch (\Exception $e) {
            Helper::Log('error', 'Error Get Blog List', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
    public function banner(Request $request)
    {
        $base_url = config('services.medikaplaza.webfront');

        try {
            $sql = "";
            $sql = "SELECT
                        bs.id,
                        bs.name as title,
                        bs.text_to_display as content,
                        bs.image_name,
                        bs.start_date,
                        bs.end_date,
			bs.active,
			bs.write_date,
                        'banner' as type
                    FROM
                        banner_setup bs
                    WHERE
                        active = true
                    order by create_date desc";
            $data = collect($this->conn->select(DB::raw($sql)));

            $data = $data->map(function($i) use ($base_url) {
                $url = sprintf('%s/web/image?model=banner.setup&id=%s&field=image_upload&t=%s', $this->base_url, $i->id, $i->write_date);
		$i->image = $url;
		$i->source = 'mr';

                return $i;
            })->filter(function($i) {
                return true;
            });

            // disable banner promotion on PRODUCTION
            /*
            $promotion_sql = "SELECT
                                    ps.id,
                                    ps.name as title,
                                    ps.description as content,
                                    ps.image_name,
                                    ps.start_date,
                                    ps.end_date,
                                    ps.active,
                                    'promotion' as type
                                    
                                FROM
                                    promotion_setup ps
                                WHERE
                                    1 = 1
                                    AND ps.active = true
                                    AND DATE(ps.end_date) > DATE(NOW())
                             ";
            $promotion = $this->conn->select(DB::raw($promotion_sql));
            $result = collect($promotion)->map(function($res){
                $res->content= strip_tags($res->content);
                $url = sprintf('%s/web/image?model=promotion.setup&id=%s&field=image_upload', $this->base_url, $res->id);
                $res->image = $url;
		$res->source = 'mr';
                 
                return $res;
            });
            $data = $result->merge($data);
            */
          
            return Helper::generalResponse(true, 'Success', $data);
        } catch (\Exception $e) {
            Helper::Log('error', 'Error Get Banner', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage(), 500);
        }
    }
}
