<?php

namespace App\Http\Controllers;

use Helper;
use App\Models\App_device;
use App\Models\App_version;
use Illuminate\Http\Request;
use App\Services\Validator\ValidatorManager;

class AppDeviceController extends Controller
{
    public function set_device(Request $request){
        $rule  = [
            'app_buildnumber'   => 'required',
            'app_version'       => 'required',
            'app_platform'      => 'required',
            'app_device'        => 'required',
        ];
        app(ValidatorManager::class)->validateRequest(__FUNCTION__, $request,  $rule,  []);

        try {
            $result = App_device::create([
                'id_user'           => auth()->id(),
                'app_buildnumber'   => $request->app_buildnumber,
                'app_version'       => $request->app_version,
                'app_platform'      => $request->app_platform,
                'app_device'        => $request->app_device,
            ]);
            return Helper::generalResponse(true, 'Success', $result);
        } catch (\Exception $e) {
            Helper::Log('error', 'Set Device Failed', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage());
        }
    }
    public function get_version(Request $request){
        try {
            $result = App_version::latest()->get();
            $result = Helper::setList($result);
            return Helper::generalResponse(true, 'Success', $result);
        } catch (\Exception $e) {
            Helper::Log('error', 'Set Device Failed', $e->getMessage());
            return Helper::generalResponse(false, 'Error', $e->getMessage());
        }
    }
}
