<?php
class Library {
    public static function statusRelationship($status)
    {
        $arr = [
            "C" => "Children",
            "E" => "Employee",
            "S" => "Spouse",
        ];
        return ($arr[$status])??"-";
    }
    public static function statusGender($status)
    {
        $arr = [
            "F" => "Female",
            "M" => "Male",
        ];
        return ($arr[$status])??"-";
    }
    public static function statusMember($status)
    {
        $arr = [
            "0" => "Reguler Member",
            "1" => "VIP Member",
        ];
        return ($arr[$status])??"-";
    }
    public static function claimStatus($status)
    {
        $arr = [
            "open"                      => "Administration Process",
            "Initial Guarantee Release" => "Inpatient Process",
            "pending_pro"               => "Inpatient Process",
            "Case Monitoring Close"     => "Inpatient Process",
            "Fina Guarantee Submited"   => "Inpatient Process",
            "Fin Guarantee Approved"    => "Dicharge Complete",
            "discharge"                 => "Dicharge Complete",
            "decline"                   => "Declined",
            "Open Claim "               => "Claim Received",
            "verified"                  => "Claim Process",
            "completed"                 => "Claim Process",
            "approved"                  => "Claim Process",
            "paid"                      => "Paid",
            "cancel"                    => "Cancel",
        ];

	if (is_null($status)) return '';
        if (! isset($arr[$status])) return $status;
        return $arr[$status];
    }
    public static function mapStatus($status)
    {
        $arr = [
            "open"                      => "Claim Process",
            "Initial Guarantee Release" => "Claim Process",
            "pending_pro"               => "Claim Process",
            "Case Monitoring Close"     => "Claim Process",
            "Fina Guarantee Submited"   => "Claim Process",
            "Fin Guarantee Approved"    => "Claim Process",
            "discharge"                 => "Claim Process",
            "decline"                   => "Declined",
            "Open Claim "               => "Claim Process",
            "verified"                  => "Claim Process",
            "completed"                 => "Claim Process",
            "approved"                  => "Claim Approved",
            "paid"                      => "Paid",
            "cancel"                    => "Cancel",
            "requested"                 => "Requested",
            "need_confirmation"         => "Need Confirmation",
        ];

	if (is_null($status)) return '';
        if (! isset($arr[$status])) return $status;
        return $arr[$status];
    }
    public static function notifPortalStatus($status)
    {
        $arr = [
            "requested" => [
                'label' => "Appointment Requested",
                'message' => "Your Appointment Requested has been successfully",
            ],
            "proceed"   => [
                'label' => "Appointment Procced",
                'message' => "Your Appointment %s has been Procced",
            ],
            "need_confirmation" => [
                'label' => "Appointment Need Confirmation",
                'message' => "Your Appointment %s has been Need Confirmation",
            ],
            "rejected"  => [
                'label' => "Appointment Rejected",
                'message' => "Your Appointment %s has been Rejected",
            ],
            "approved"  => [
                'label' => "Appointment Approved",
                'message' => "Your Appointment %s has been Approved",
            ],
            "paid"  => [
                'label' => "Appointment Paid",
                'message' => "Your Appointment %s has been Paid",
            ],
            "discharge"  => [
                'label' => "Appointment Discharge",
                'message' => "Your Appointment %s has been Discharge",
            ],
            "decline"  => [
                'label' => "Appointment Declined",
                'message' => "Your Appointment %s has been Declined",
            ],
        ];
        if (! isset($arr[$status])) return $status;
        return $arr[$status];
    }
    public static function notifReimbursStatus($status)
    {
        $arr = [
            "requested" => [
                'label' => "Claim Reimburment Requested",
                'message' => "Your Appointment Requested has been successfully",
            ],
            "proceed"   => [
                'label' => "Claim Reimburment Procced",
                'message' => "Your Claim Reimburment %s has been Procced",
            ],
            "need_confirmation" => [
                'label' => "Claim Reimburment Need Confirmation",
                'message' => "Your Claim Reimburment %s has been Need Confirmation",
            ],
            "rejected"  => [
                'label' => "Claim Reimburment Rejected",
                'message' => "Your Claim Reimburment %s has been Rejected",
            ],
            "approved"  => [
                'label' => "Claim Reimburment Approved",
                'message' => "Your Claim Reimburment %s has been Approved",
            ],
            "paid"  => [
                'label' => "Claim Reimburment Paid",
                'message' => "Your Claim Reimburment %s has been Paid",
            ],
            "discharge"  => [
                'label' => "Claim Reimburment Discharge",
                'message' => "Your Claim Reimburment %s has been Discharge",
            ],
            "decline"  => [
                'label' => "Claim Reimburment Declined",
                'message' => "Your Claim Reimburment %s has been Declined",
            ],
        ];
        if (! isset($arr[$status])) return $status;
        return $arr[$status];
    }
    public static function serviceType($status)
    {
        $arr = [
            "reimburse" => "Reimbursement",
            "cashless"  => "Cashless",
        ];
        return ($arr[$status])??"-";
    }
    public static function service_label($service)
    {
        $arr = [
            "consul"        => "Konsul Dokter",
            "medicine"      => "Beli Obat",
            "appointment"   => "Buat Janji Dokter",
            "lab"           => "Cek Lab",
        ];
        return ($arr[$service])??"-";
    }
    public static function policyStatus($status)
    {
        $arr = [
            "A" => "Active",
            "N" => "NonActive",
        ];
        return ($arr[$status])??"-";
    }
    public static function getDay($day)
    {
        $arr = [
            "0" => "Sunday",
            "1" => "Monday",
            "2" => "Tuesday",
            "3" => "Wednesday",
            "4" => "Thursday",
            "5" => "Friday",
            "6" => "Saturday",
        ];
        return ($arr[$day])??"-";
    }
    public static function getPaymentChannel($code)
    {
        $arr = [
            "0"     => "Asuransi",
            "402"   => "Permata Virtual Account / PermataNet",
            "408"   => "Maybank Virtual Account",
            "702"   => "BCA Virtual Account",
            "708"   => "Danamon Virtual Account",
            "800"   => "BRI Virtual Account",
            "801"   => "BNI Virtual Account",
            "802"   => "Mandiri Virtual Account",
            "825"   => "CIMB Virtual Account",
        ];
        return ($arr[$code])??"-";
    }
    public static function getPaymentChannelCode($code)
    {
        $arr = [
            "0"     => "Asuransi",
            // Permata Virtual Account / PermataNet
            "402"   => "0130475",
            // Maybank Virtual Account
            "408"   => "0160131",
            // BCA Virtual Account
            "702"   => "0140397",
            // Danamon Virtual Account
            "708"   => "0110042",
            // BRI Virtual Account
            "800"   => "0020307",
            // BNI Virtual Account
            "801"   => "0090010",
            // Mandiri Virtual Account
            "802"   => "0080017",
            // CIMB Virtual Account
            "825"   => "0220026",
        ];
        return ($arr[$code])??"-";
    }
    
}
