<?php

use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\Storage;
use Symfony\Component\Console\Input\Input;
use Illuminate\Pagination\LengthAwarePaginator;

class Helper
{
	public static function generateSessionId()
	{
		return strtoupper(uniqid());
	}
	
	public static function getMsgErrorDb($e){
		if ($e instanceof \Illuminate\Database\QueryException) {
			if ($e->getCode() == '23000') {
				$ex = $e->getPrevious();
				if (get_class($ex) == 'PDOException') {
					return $ex->errorInfo[2];
				}
			}
		}
		return false;
	}
	public static function getAuthPermission($group)
	{
		$user_code = Config('medikaplaza.permission');
		$result = ($user_code[$group]) ?? false;
		return $result;
	}
	public static function roleCaption($role)
    {
		$role_label = Config('medikaplaza.group_label');
		if (!is_null($role)) {
			return ($role_label[$role])??"-";
		}
		return $role_label;
    }
	public static function userGroupName($user_group)
	{
		$user_code = Config('medikaplaza.group_label');
		$group = ($user_code[$user_group]) ?? "-";
		$name = ($group) ?? "-";
		return $name;
	}
	public static function setAccess($user_group)
	{
		$result = [];
		$group  = (Config('medikaplaza.user_group')[$user_group]) ?? [];
		//** Mapping Access */
		if (isset($group['abilities'])) {
			$result = $group['abilities'];
		}
		return $result;
	}
	public static function generateUserAbilities($code)
    {
        $abilities = [];
        $access_list = config("medikaplaza.user_group");
        foreach ($access_list as $key => $value) {
            if (isset($value['manage']) && in_array($code, $value['manage'])) {
                $abilities[] = [
                    'action' => 'manage',
                    'subject' => $key
                ];
            }
            if (isset($value['read']) && in_array($code, $value['read'])) {
                $abilities[] = [
                    'action' => 'read',
                    'subject' => $key
                ];
            }
            if (isset($value['create']) && in_array($code, $value['create'])) {
                $abilities[] = [
                    'action' => 'create',
                    'subject' => $key
                ];
            }
            if (isset($value['update']) && in_array($code, $value['update'])) {
                $abilities[] = [
                    'action' => 'update',
                    'subject' => $key
                ];
            }
            if (isset($value['delete']) && in_array($code, $value['delete'])) {
                $abilities[] = [
                    'action' => 'delete',
                    'subject' => $key
                ];
            }
        }
        return $abilities;
    }
	public static function isJson($string) {
		json_decode($string);
		return (json_last_error() == JSON_ERROR_NONE);
	}
	public static function generalResponse($status, $message, $data, $httpstatus = 200)
	{
		$response = [
			"status" => $status,
			"message" => $message,
			"data" => $data
		];
		return response()->json($response, $httpstatus);
	}
	public static function setAvatar($name){
		$name  = str_replace(' ','',$name);
		$url = "https://ui-avatars.com/api/?size=128&name=".$name;
		return $url;
	}
	public static function setList($data)
	{
		$result = [
			'list'      => $data->toArray(),
			'total'     => $data->count()
		];
		return $result;
	}
	public static function setData($data)
	{
		$result = [
			'data'      => $data
		];
		return $result;
	}
	public function pagination($query, $limit, $page){
		if ($limit) {
			$page = ($page) ? intval($page) : 1;
			$limit = ($limit) ? intval($limit) : 10;
			$offset = ($page) ? (($page - 1) * $limit) : 0;
			$query .= " LIMIT " . $limit . " OFFSET " . $offset;
		}
		return $query;

	}
	public function arrayPaginator($array, $request, $perPage = 10) {
		$page = $request->page ?? 1;
		if ($request->has('limit')) {
            $perPage = $request->limit;
        } 
        $offset = ($page * $perPage) - $perPage;

		$items = array_values(array_slice(
                $array,
                $offset,
                $perPage,
                true
            ));

        return new LengthAwarePaginator(
            $items,
            count($array),
            $perPage,
            $page,
            ['path' => $request->url(), 'query' => $request->query()]
        );
	}
	public static function setPaginate($data)
	{
		$result = [
			'data'			=> $data->items(),
			"current_page"	=> $data->currentPage(),
			"last_page"		=> $data->lastPage(),
			"total"			=> $data->total(),
			
		];

		return $result;
	}
	public static function setPagination($data)
	{
		$result = [
			'list'			=> $data->items(),
			"total"			=> $data->total(),
			'pagination'	=> [
				"total_page"		=> $data->lastPage(),
				"current"			=> $data->currentPage(),
				"count"				=> $data->count(),
				"total"				=> $data->total(),
				"per_page"			=> (int) $data->perPage(),
				"next"				=> $data->hasMorePages(),
				"prev"				=> !$data->onFirstPage(),
				"list"				=> self::paginationLink($data->lastPage(), $data->currentPage()),
			],
		];

		return $result;
	}
	private static function paginationLink($total, $current_page)
	{
		if (empty($current_page)) {
			$current_page = 1;
		}
		if ($total <= 5) {
			$awal = 1;
			$akhir = $total;
			$awal_active = 'false';
			$akhir_active = 'false';
		} else if (($total > 5) && ($current_page <= 4)) {
			$awal = 1;
			$akhir = $current_page + 2;
			$awal_active = 'false';
			$akhir_active = 'true';
		} else if (($current_page > ($total - 5)) && ($total > 5)) {
			$awal = $total - 5;
			$akhir = $total;
			$awal_active = 'true';
			$akhir_active = 'false';
		} else if (($total > 5) && ($current_page >= 2)) {
			$awal = $current_page - 2;
			$akhir = $current_page + 2;
			$awal_active = 'true';
			$akhir_active = 'true';
		}
		$paging = array();
		if ($awal_active === 'true') {
			array_push(
				$paging,
				array(
					"page" => '1',
					"is_active" => ($current_page == '1') ? true : false
				)
			);
			array_push(
				$paging,
				array(
					"page" => '...',
					"is_active" => false
				)
			);
		}
		for ($i = $awal; $i <= $akhir; $i++) {
			array_push(
				$paging,
				array(
					"page" => $i,
					"is_active" => ($current_page == $i) ? true : false
				)
			);
		}
		if ($akhir_active === 'true') {
			array_push(
				$paging,
				array(
					"page" => '...',
					"is_active" => false
				)
			);
			array_push(
				$paging,
				array(
					"page" => $total,
					"is_active" => ($current_page == $total) ? true : false
				)
			);
		}
		return $paging;
	}
	public static function otpGenerator($length = 6)
	{
		$pool = '0123456789';
		return substr(str_shuffle(str_repeat($pool, 5)), 0, $length);
	}
	public static function codeGenerator($length = 8)
	{
		$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
		$randomString = '';
	 
		for ($i = 0; $i < $length; $i++) {
			$index = rand(0, strlen($characters) - 1);
			$randomString .= $characters[$index];
		}
	 
		return $randomString;
	}
	public static function Log($type = 'info', $msg = '', $data = [], $exception = null)
	{
		if (is_object($data)) {
			$data = $data->toArray() ?? (array) $data;
		}
		if (!is_array($data) && !is_object($data))
			$data = array($data);

		if ($exception != null) {
			$data['payload'] = [
				'class' => class_basename($exception),
				'file' => basename($exception->getFile()),
				'line' => $exception->getLine(),
				'params' => request()->all()
			];
		}

		$identity = (isset(auth()->user()->email) && !is_null(auth()->user()->email)) ? session()->token() . " | " . auth()->user()->email : session()->token();

		if ($type == 'info') {
			Log::info($identity . " | " . $msg . " -", $data);
		} else if ($type == 'error') {
			Log::error($identity . " | " . $msg . " -", $data);
		} else if ($type == 'warning') {
			Log::warning($identity . " | " . $msg . " -", $data);
		} else if ($type == 'notice') {
			Log::notice($identity . " | " . $msg . " -", $data);
		} else if ($type == 'debug') {
			Log::debug($identity . " | " . $msg . " -", $data);
		}
		return true;
	}
	public static function LogFaspay($type = 'info', $msg = '', $data = [], $exception = null)
	{
		if (is_object($data)) {
			$data = $data->toArray() ?? (array) $data;
		}
		if (!is_array($data) && !is_object($data))
			$data = array($data);

		if ($exception != null) {
			$data['payload'] = [
				'class' => class_basename($exception),
				'file' => basename($exception->getFile()),
				'line' => $exception->getLine(),
				'params' => request()->all()
			];
		}

		$identity = (isset(auth()->user()->email) && !is_null(auth()->user()->email)) ? session()->token() . " | " . auth()->user()->email : session()->token();

		if ($type == 'info') {
			Log::channel('faspay')->info($identity . " | " . $msg . " -", $data);
		} else if ($type == 'error') {
			Log::channel('faspay')->error($identity . " | " . $msg . " -", $data);
		} else if ($type == 'warning') {
			Log::channel('faspay')->warning($identity . " | " . $msg . " -", $data);
		} else if ($type == 'notice') {
			Log::channel('faspay')->notice($identity . " | " . $msg . " -", $data);
		} else if ($type == 'debug') {
			Log::channel('faspay')->debug($identity . " | " . $msg . " -", $data);
		}
		return true;
	}
	public static function LogDashboard($type = 'info', $msg = '', $data = [], $exception = null)
	{
		if (is_object($data)) {
			$data = $data->toArray() ?? (array) $data;
		}
		if (!is_array($data) && !is_object($data))
			$data = array($data);

		if ($exception != null) {
			$data['payload'] = [
				'class' => class_basename($exception),
				'file' => basename($exception->getFile()),
				'line' => $exception->getLine(),
				'params' => request()->all()
			];
		}

		$identity = (isset(auth()->guard('web_users')->user()->email) && !is_null(auth()->guard('web_users')->user()->email)) ? session()->token() . " | " . auth()->guard('web_users')->user()->email : session()->token();

		if ($type == 'info') {
			Log::channel('dashboard')->info($identity . " | " . $msg . " -", $data);
		} else if ($type == 'error') {
			Log::channel('dashboard')->error($identity . " | " . $msg . " -", $data);
		} else if ($type == 'warning') {
			Log::channel('dashboard')->warning($identity . " | " . $msg . " -", $data);
		} else if ($type == 'notice') {
			Log::channel('dashboard')->notice($identity . " | " . $msg . " -", $data);
		} else if ($type == 'debug') {
			Log::channel('dashboard')->debug($identity . " | " . $msg . " -", $data);
		}
		return true;
	}
	
	public static function pembulatan_rupiah($value)
	{
		$value = intval($value);
		if (strlen($value) >= 3) {
			$depan = substr($value, 0, (strlen($value) - 3));
			$ratusan = substr($value, (strlen($value) - 3), 3);
			if ($ratusan >= 1 && $ratusan < 250) {
				$ratusan = '000';
			} else if ($ratusan >= 250 && $ratusan < 500) {
				$ratusan = '250';
			} else if ($ratusan >= 500 && $ratusan < 750) {
				$ratusan = '500';
			} else if ($ratusan >= 750 && $ratusan < 1000) {
				if (strlen($value) == 3) {
					$depan = substr($value, 0, (strlen($value) - 2));
					$ratusan = substr($value, (strlen($value) - 2), 2);

					if ($ratusan >= 1 && $ratusan < 50) {
						$ratusan = '00';
					} else {
						$ratusan = '50';
					}
				} else {
					$depan = substr($value, 0, (strlen($value) - 2));
					$ratusan = substr($value, (strlen($value) - 2), 2);

					if ($ratusan >= 51 && $ratusan < 100) {
						$ratusan = '50';
					} else {
						$ratusan = '00';
					}
				}
			}

			$value = $depan . '' . $ratusan;
		}

		return number_format($value, 2);
	}

	public static function UUID()
	{
		return sprintf(
			'%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
			// 32 bits for "time_low"
			mt_rand(0, 0xffff),
			mt_rand(0, 0xffff),

			// 16 bits for "time_mid"
			mt_rand(0, 0xffff),

			// 16 bits for "time_hi_and_version",
			// four most significant bits holds version number 4
			mt_rand(0, 0x0fff) | 0x4000,

			// 16 bits, 8 bits for "clk_seq_hi_res",
			// 8 bits for "clk_seq_low",
			// two most significant bits holds zero and one for variant DCE1.1
			mt_rand(0, 0x3fff) | 0x8000,

			// 48 bits for "node"
			mt_rand(0, 0xffff),
			mt_rand(0, 0xffff),
			mt_rand(0, 0xffff)
		);
	}


	//**For storage images */
	public static function generateImgUrl($dir, $file)
	{
		$disk = Storage::disk('images');
		$filename = sprintf('%s/%s', $dir, $file);
		//if (is_null($file) || $file == '' || !$disk->exists($filename)) {
		if (is_null($file) || $file == '') {
			return url('img/no_image.png');
		}
		//return $disk->url($filename);
		return asset('img/'.$filename);
	}
	public static function increment_code($count)
	{
		$result = '';
		$len = strlen($count);

		switch ($len) {
			case 1:
				$result = "00000" . $count;
				break;
			case 2:
				$result = "0000" . $count;
				break;
			case 3:
				$result = "000" . $count;
				break;
			case 4:
				$result = "00" . $count;
				break;
			case 5:
				$result = "0" . $count;
				break;
			case 6:
				$result = $count;
				break;
		}

		return $result;
	}

	public static function uploadImg($key = 'file', $directory = 'img', $prefix = 'file')
	{
		$file = Request::file($key);
		$original = $file->getClientOriginalName();

		try {

			$prefix = $prefix == 'file' ? $key : $prefix;
			$filename = sprintf('%s_%s_%s.%s', date('Y-m-d'), $prefix, md5(microtime(true)), $file->extension());

			$file->storeAs($directory, $filename, 'images');

			return $filename;
		} catch (\Exception $e) {
			self::log("Upload Image", $e->getMessage());
			$filename = 'nopic.png';
		}
	}
	public static function isExistImg($dir, $file)
	{
		return Storage::disk($dir)->exists($file);
	}
	public static function deleteImgFile($dir, $file)
	{
		$filename = sprintf('%s/%s', $dir, $file);
		return Storage::disk($dir)->delete($filename);
	}
	public static function humanFileSize($size,$unit="") {
		if( (!$unit && $size >= 1<<30) || $unit == "GB")
		  return number_format($size/(1<<30),2)."GB";
		if( (!$unit && $size >= 1<<20) || $unit == "MB")
		  return number_format($size/(1<<20),2)."MB";
		if( (!$unit && $size >= 1<<10) || $unit == "KB")
		  return number_format($size/(1<<10),2)."KB";
		return number_format($size)." bytes";
	}

	public static function uploadFileLocal($key = 'file', $directory = 'file', $prefix = 'file')
	{
		$file = Request::file($key);
		try {
			$prefix = $prefix == 'file' ? $key : $prefix;
			$filename = sprintf('%s_%s_%s.%s', date('Ymd'), $prefix, date('his') . rand(0, 999), $file->extension());
			$file->storeAs($directory, $filename, 'public');
			return $filename;
		} catch (\Exception $e) {
			self::log("Upload Image", $e->getMessage());
			$filename = '';
		}
	}
	public static function isExistFileLocal($dir, $file)
	{
		$filename = sprintf('%s/%s', $dir, $file);
		return Storage::disk('public')->exists($filename);
	}
	public static function deleteFileLocal($dir, $file)
	{
		$filename = sprintf('%s/%s', $dir, $file);
		return Storage::disk('public')->delete($filename);
	}

	public static function encodeJWT($SECRET,$header, $data)
	{
		$header = json_encode($header);
		$base64UrlHeader = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($header));
		$payload = json_encode($data);
		$base64UrlPayload = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($payload));
		$signature = hash_hmac('sha256', $base64UrlHeader . "." . $base64UrlPayload, $SECRET, true);
		$base64UrlSignature = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($signature));
		$output = $base64UrlHeader . "." . $base64UrlPayload . "." . $base64UrlSignature;
		return $output;
	}
	public static function decodeJWT($SECRET, $data)
	{

		$header = base64_decode(str_replace('_', '/', str_replace('-', '+', explode('.', $data)[0])));
		$payload = base64_decode(str_replace('_', '/', str_replace('-', '+', explode('.', $data)[1])));
		$signature = base64_decode(str_replace('_', '/', str_replace('-', '+', explode('.', $data)[2])));

		$base64UrlHeader = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($header));
		$base64UrlPayload = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($payload));

		$signature_check = hash_hmac('sha256', $base64UrlHeader . "." . $base64UrlPayload, $SECRET, true);
		if ($signature == $signature_check) {
			return $payload;
		}
		return false;
	}
	public static function passwordGenerator($length = 8)
	{
		$pool = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ&%#$';
		return substr(str_shuffle(str_repeat($pool, 5)), 0, $length);
	}
	public static function textToSlug($text='', $space = "-") {
		$text = trim($text);
		if (empty($text)) return '';
		  $text = preg_replace("/[^a-zA-Z0-9\-\s]+/", "", $text);
		  $text = strtolower(trim($text));
		  $text = str_replace(' ', $space, $text);
		  $text = $text_ori = preg_replace('/\-{2,}/', $space, $text);
		  return $text;
	}
}
