<?php

namespace App\Exports;

use PhpOffice\PhpSpreadsheet\Cell\Cell;
use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Cell\DataType;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use PhpOffice\PhpSpreadsheet\Cell\DefaultValueBinder;

class AppointmentExport extends DefaultValueBinder implements FromArray, WithHeadings, WithColumnFormatting, WithStyles, WithColumnWidths
{
    use Exportable;
    private $data;

    public function __construct($data)
    {
        $this->data = $data;
    }
    /**
    * @return \Illuminate\Support\Collection
    */
    public function headings(): array
    {
        return [
            "No.",
            "Appointment ID",
            "FULLNAME",
            "COMPANY NAME",
            "EMAIL",
            "DOCTOR",
            "GENDER",
            "PHONE NUMBER",
            "PATIENT STATUS",
            "TRANSACTION AMOUNT",
            "ADMISSION DATE",
            "CREATED AT",
            "STATUS",
        ];
    }

    public function columnFormats(): array
    {
        return [
            'H' => NumberFormat::FORMAT_NUMBER,
            'J' => NumberFormat::FORMAT_NUMBER,
            'K' => NumberFormat::FORMAT_DATE_DATETIME,
            'L' => NumberFormat::FORMAT_DATE_DATETIME,
        ];
    }
    public function columnWidths(): array
    {
        return [
            'A' => 5,
            'B' => 25,            
            'C' => 25,            
            'D' => 30,            
            'E' => 15,            
            'F' => 20,            
            'G' => 15,            
            'H' => 20,            
            'I' => 20,            
            'J' => 20,
            'K' => 20,
            'L' => 20,
        ];
    }
    public function styles(Worksheet $sheet)
    {
        return [
            'A'  => ['alignment' => ['horizontal' => 'left']],
            'B'  => ['alignment' => ['horizontal' => 'left']],
            'C'  => ['alignment' => ['horizontal' => 'left']],
            'D'  => ['alignment' => ['horizontal' => 'left']],
            'E'  => ['alignment' => ['horizontal' => 'left']],
            'F'  => ['alignment' => ['horizontal' => 'left']],
            'G'  => ['alignment' => ['horizontal' => 'left']],
            'H'  => ['alignment' => ['horizontal' => 'left']],
            'I'  => ['alignment' => ['horizontal' => 'left']],
            'J'  => ['alignment' => ['horizontal' => 'left']],
        ];
    }
    public function array(): array
    {
        $result = [];
        foreach($this->data as $key => $value){
                $result[$key]["No."]                = $key + 1;
                $result[$key]["Appointment ID"]     = $value->trx_no;
                $result[$key]["FULLNAME"]           = $value->cust_name;
                $result[$key]["COMPANY NAME"]       = $value->company_name;
                $result[$key]["EMAIL"]              = $value->email;
                $result[$key]["DOCTOR"]             = $value->doctor_name;
                $result[$key]["GENDER"]             = $value->gender;
                $result[$key]["PHONE NUMBER"]       = $value->phone;
                $result[$key]["PATIENT STATUS"]     = $value->patient_type;
                $result[$key]["TRANSACTION AMOUNT"] = $value->trx_amount;
                $result[$key]["ADMISSION DATE"]     = $value->date_consul. ' '. $value->time_consul;
                $result[$key]["CREATED AT"]         = $value->created_at;
                $result[$key]["STATUS"]             = $value->trx_status;
        }
        return $result;
    }
}
