<?php

namespace App\Exceptions;

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Throwable;

class Handler extends ExceptionHandler
{
    /**
     * A list of the exception types that are not reported.
     *
     * @var array<int, class-string<Throwable>>
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed for validation exceptions.
     *
     * @var array<int, string>
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     *
     * @return void
     */
    public function register()
    {
        $this->reportable(function (Throwable $e) {
            //
        });
    }

    public function render($request, Throwable $e)
    {
        $responseCode = $this->isHttpException($e) ? $e->getStatusCode() : 500;
        $message = $e->getMessage();

        if ($responseCode == 404) {
            $message = 'Endpoint not found';
        }

        $response = [
			"status" => false,
			"message" => $message,
			"data" => [],
		];
        return response()->json($response, $responseCode);
    }
}
