<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // $schedule->command('inspire')->hourly();
        $schedule->command('core:worker')->everyMinute();
        $schedule->command('telmed:cancel')->everyMinute();
        $schedule->command('telmed:done')->everyMinute();
        $schedule->command('telmed:ongoing')->everyMinute();
        $schedule->command('send:result')->everyMinute();
        $schedule->command('send:result_email')->everyMinute();
        $schedule->command('telmed:reminder')->everyMinute();
        $schedule->command('payment:cancel')->everyMinute();
        $schedule->command('send:faspay')->everyMinute();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
