<?php

namespace App\Console\Commands;

use App\Jobs\JobTelmedReminder;
use Exception;
use Carbon\Carbon;
use App\Services\Firebase;
use App\Models\Notifikasi_web;
use Illuminate\Console\Command;
use App\Repository\QiscusManager;
use App\Models\Trx_history_telmed;
use Illuminate\Support\Facades\Log;
use App\Repository\TelemedicineManager;

class SetTelmedReminder extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'telmed:reminder';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Set transaction telmed reminder';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public $firebase;
    public $REPO;
    public $qiscus;
    public function __construct()
    {
        parent::__construct();
        $this->firebase    = new Firebase();
        $this->REPO         = new TelemedicineManager();
        $this->qiscus       = new QiscusManager();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        date_default_timezone_set("Asia/Jakarta");
        $now = date("Y-m-d");
        try{
            $status = Trx_history_telmed::STS_WAIT_APPOINTMNET;
            $trx = Trx_history_telmed::whereDate('date_consul', '=' , $now)
                    ->where('trx_status', $status)
                    ->orderBy('id','DESC')
                    ->get();
            $count = $trx->count();
            
            if($count>0){
                foreach($trx as $val){
                    Log::channel('schedule_trx')->info("$val->trx_no set to transaction reminder send to queue");
                    $send = dispatch(new JobTelmedReminder($val)); 
                }
            }
            return 1;
        }catch(Exception $e){
            Log::channel('schedule_trx')->error($e->getMessage());
            return 0;
        }
    }
}
