<?php

namespace App\Console\Commands;

use App\Jobs\JobTelmedOngoing;
use Exception;
use Carbon\Carbon;
use Illuminate\Console\Command;
use App\Models\Trx_history_telmed;
use Illuminate\Support\Facades\Log;
use App\Repository\TelemedicineManager;

class SetTelmedOngoing extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'telmed:ongoing';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Set transaction telmed ongoing';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        date_default_timezone_set("Asia/Jakarta");
        $now = date("Y-m-d");
        

        $telmed = new TelemedicineManager();
        try{
            $trx = Trx_history_telmed::where('date_consul', '=' , $now)
                    ->where('trx_status', Trx_history_telmed::STS_WAIT_APPOINTMNET)
                    ->orderBy('id','DESC')
                    ->get();
            $count = $trx->count();

            if($count>0){
                Log::channel('schedule_trx')->info("Found $count transaction to set ongoing");
                foreach($trx as $val){
                    Log::channel('schedule_trx')->info("$val->trx_no set to transaction ongoing send to queue");
                    $send = dispatch(new JobTelmedOngoing($val));
                }
            }
            return 1;
        }catch(Exception $e){
            Log::channel('schedule_trx')->error($e->getMessage());
            return 0;
        }
    }
}
