<?php

namespace App\Console\Commands;

use App\Jobs\JobTelmedDone;
use App\Models\Icd10_telmed;
use App\Models\Recipe_telmed;
use App\Models\Soap_telmed;
use Exception;
use Carbon\Carbon;
use Illuminate\Console\Command;
use App\Models\Trx_history_telmed;
use App\Repository\TelemedicineManager;
use Illuminate\Support\Facades\Log;

class SetTelmedDone extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'telmed:done';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Set transaction telmed done';
   

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public $telmed;
    public function __construct()
    {
        $this->telmed = new TelemedicineManager();
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    
    public function handle()
    {
        date_default_timezone_set("Asia/Jakarta");
        $now = date("Y-m-d");
        
        try{
            $trx = Trx_history_telmed::where('date_consul', '=' , $now)
                ->where('trx_status', Trx_history_telmed::STS_ONGOING)
                ->orderBy('id','DESC')
                ->get();
            $count = $trx->count();
           
            if($count>0){
                foreach($trx as $val){
                    Log::channel('schedule_trx')->info("$val->trx_no set to transaction done send to queue");
                    $send = dispatch(new JobTelmedDone($val));
                }
            }
            return 1;
        }catch(Exception $e){
            Log::channel('schedule_trx')->error($e->getMessage());
            return 0;
        }
        
    }
}
