<?php

namespace App\Console\Commands;

use App\Jobs\JobTelmedCancel;
use Exception;
use Illuminate\Console\Command;
use App\Models\Trx_history_telmed;
use Illuminate\Support\Facades\Log;

class SetTelmedCancel extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'telmed:cancel';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Set transaction telmed cancel';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        date_default_timezone_set("Asia/Jakarta");
        $now = date("Y-m-d H:i:s");
        try{
            $trx = Trx_history_telmed::where('trx_expired', '<=' , $now)
                ->where('trx_status', Trx_history_telmed::STS_PENDING)->orderBy('id','DESC')->get();
            $count = $trx->count();
            
            if($count>0){
                foreach($trx as $val){
                    Log::channel('schedule_trx')->info("$val->trx_no set to transaction done send to queue");
                    $send = dispatch(new JobTelmedCancel($val));
                }
            }
            return 1;
        }catch(Exception $e){
            Log::channel('schedule_trx')->error($e->getMessage());
            return 0;
        }
    }
}
