<?php

namespace App\Console\Commands;

use App\Jobs\JobTelmedCancel;
use App\Jobs\JobPaymentCancel;
use App\Models\Payment_telmed;
use App\Models\Trx_history_telmed;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class SetPaymentCancel extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'payment:cancel';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Set transaction payment cancel';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        date_default_timezone_set("Asia/Jakarta");
        try {
            $trx = Trx_history_telmed::query()
                ->where('trx_status', Trx_history_telmed::STS_WAIT_PAYMENT)
                ->whereHas('payment', function($q) {
                    $now = date("Y-m-d H:i:s");
                    $q->where('pay_exp_date', '<' , $now)
                        ->where('pay_message', Payment_telmed::STS_PENDING);
                })
                ->orderBy('id', 'DESC')
                ->get();
            $count = $trx->count();

            if ($count > 0) {
                foreach ($trx as $val) {
                    Log::channel('schedule_trx')->info("$val->trx_no set to payment cancel send to queue");
                    $send = dispatch(new JobPaymentCancel($val));
                }
            }
            return 1;
        } catch (\Exception $e) {
            Log::channel('schedule_trx')->error($e->getMessage());
            return 0;
        }
    }
}
