<?php

namespace App\Console\Commands;

use App\Jobs\JobSendResultEmail;
use Exception;
use Carbon\Carbon;
use App\Models\Soap_telmed;
use App\Models\Icd10_telmed;
use App\Models\Recipe_telmed;
use Illuminate\Console\Command;
use App\Repository\MPOneManager;
use App\Models\Trx_history_telmed;
use Illuminate\Support\Facades\Log;
use App\Repository\TelemedicineManager;
use Illuminate\Support\Facades\Storage;

class SendResultEmail extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'send:result_email';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send Result Email transaction';
   

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public $telmed;
    public $repoMpOne;
    public function __construct()
    {
        $this->telmed = new TelemedicineManager();
        $this->repoMpOne    = new MPOneManager();
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    
    public function handle()
    {
        date_default_timezone_set("Asia/Jakarta");
       
        try{
            $status = false;
            $done = Trx_history_telmed::STS_DONE;
            $trx = Trx_history_telmed::where('is_send_result', $status)
                ->where('trx_status', $done)
                ->orderBy('id','DESC')
                ->get();
            $count = $trx->count();
           
            if($count>0){
                foreach($trx as $val){
                    if (!$val->relationLoaded('soap')) {
                        $val->load('soap');
                    }
                    if (!$val->relationLoaded('icd10')) {
                        $val->load('icd10');
                    }
                    if (!$val->relationLoaded('recipe')) {
                        $val->load('recipe');
                    }
                    if (!$val->relationLoaded('payment')) {
                        $val->load('payment');
                    }
                    if (is_null($val->payment)) {
                        throw new \Exception('CRON | Payment has not been paid');    
                    }
                    if (is_null($val->soap)) {
                        $msg = "CRON | $val->trx_no Telmed does not have SOAP yet";
                        Log::channel('schedule_trx')->info($msg);
                        continue;
                    }
                    Log::channel('schedule_trx')->info("$val->trx_no send result email to queue");
                    $send = dispatch(new JobSendResultEmail($val));
                    Log::channel('schedule_trx')->info("$val->trx_no success queue");
                    
                }
            }
            return 1;
        }catch(Exception $e){
            Log::channel('schedule_trx')->error($e->getMessage());
            return 0;
        }
    }
}
