<?php

namespace App\Console\Commands;

use App\Jobs\JobSendResult;
use Helper;
use Exception;
use Carbon\Carbon;
use App\Models\MPOne_log;
use App\Models\Recipe_telmed;
use Illuminate\Console\Command;
use App\Repository\MPOneManager;
use App\Models\Trx_history_telmed;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class SendResult extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'send:result';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send result to MPONE';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public $repoMpOne;
    public $conn;
    public function __construct()
    {
        $this->repoMpOne   = new MPOneManager();
        if(config('services.medikaplaza.telemedicine_mode') == 'production'){
            $this->conn        = DB::connection('pgsql');
        }else{
            $this->conn        = DB::connection('stag_medika');
        }
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        date_default_timezone_set("Asia/Jakarta");
        $status_done = Trx_history_telmed::STS_DONE;
        
        try{
            $trx = Trx_history_telmed::where('trx_status', $status_done)->orderBy('id','DESC')->get();
           
            $count = $trx->count();
           
            if($count>0){
                foreach($trx as $val){
                    // echo $val->trx_no;
                    if (!$val->relationLoaded('soap')) {
                        $val->load('soap');
                    }
                    if (!$val->relationLoaded('icd10')) {
                        $val->load('icd10');
                    }
                    if (!$val->relationLoaded('recipe')) {
                        $val->load('recipe');
                    }
                    if (!$val->relationLoaded('payment')) {
                        $val->load('payment');
                    }
                    if (is_null($val->payment)) {
                        throw new \Exception('CRON | Payment has not been paid');    
                    }
                    if (is_null($val->soap)) {
                        $msg = "CRON | $val->trx_no Telmed does not have SOAP yet";
                        Log::channel('schedule_trx')->info($msg);
                        continue;
                    }
                    Log::channel('schedule_trx')->info("$val->trx_no send result to queue");
                    $send = dispatch(new JobSendResult($val));
                }
            }
            return 1;
        }catch(Exception $e){
            Log::channel('schedule_trx')->error($e->getMessage());
            return 0;
        }
    }
}
