<?php

namespace App\Console\Commands;

use Helper;
use Exception;
use Carbon\Carbon;
use App\Models\MPOne_log;
use App\Models\Recipe_telmed;
use Illuminate\Console\Command;
use App\Jobs\JobSendFaspayMpone;
use App\Repository\MPOneManager;
use App\Models\Trx_history_telmed;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class SendFaspayMpone extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'send:faspay';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send faspay to MPONE';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public $repoMpOne;
    public $conn;
    public function __construct()
    {
        $this->repoMpOne   = new MPOneManager();
        if(config('services.medikaplaza.telemedicine_mode') == 'production'){
            $this->conn        = DB::connection('pgsql');
        }else{
            $this->conn        = DB::connection('stag_medika');
        }
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        date_default_timezone_set("Asia/Jakarta");
        $status_done = Trx_history_telmed::STS_DONE;
        
        try{
            $trx = Trx_history_telmed::where('trx_status', $status_done)
                    ->whereIn('patient_type',['member','retail'])
                    ->whereNotNull('taken')
                    ->where(function($query) {
                        $query->whereNull('is_send_faspay_telmed')
                        ->orWhereNull('is_send_faspay_prescription')
                        ->orWhere('is_send_faspay_telmed',false)
                        ->orWhere('is_send_faspay_prescription',false);
                    })
                    ->orderBy('id','DESC')
                    ->get();
           
            $count = $trx->count();
            Log::channel('schedule_trx')->info("CRON | send faspay to MPONE  $count transaction");
           
            if($count>0){
                foreach($trx as $val){
                    $send = dispatch(new JobSendFaspayMpone($val));
                }
            }
            return 1;
        }catch(Exception $e){
            Log::channel('schedule_trx')->error($e->getMessage());
            return 0;
        }
    }
}
