<?php

namespace App\Console\Commands;

use Helper;
use App\Models\Web_user;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class GenerateUser extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'generate:user';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generate user';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $group = 2001;
        $emails = ['dr.angga.nugraha@medikaplaza.com',
        'yosephine@medikaplaza.com',
        'enjelita@medikaplaza.com',
        'Dicki.Herlianto@medikaplaza.com',];
        foreach ($emails as $email){
            $user = Web_user::where('email', 'ILIKE', $email)->first();
            if (is_null($user)) {
                $name = explode("@",$email);
                $payload = [
                    'name'      => $name[0],
                    'email'     => $email,
                    'password'  => Hash::make("password"),
                    'status'    => 1,
                    'conf_code' => Helper::UUID(),
                    'reset_pass_code' => Helper::UUID(),
                    'via' => 'app',
                    'group' => $group,
                ];
                $data = Web_user::create($payload);
                if(!$data){
                    return Helper::generalResponse(false, 'Failed to create new account.', [], 500);
                }
    
                $q = "SELECT id FROM res_partner
                WHERE 1=1
                    AND email_normalized ILIKE '%s'
                    AND master_ketenagaan_id is not null
                    AND kode_personil IS NOT NULL 
                    AND unit_kerja IS NOT NULL
                    AND is_dokter = true
                    AND active = true
                LIMIT 1";
                $q = sprintf($q, $email);
                $conn = DB::connection('pgsql');
                $checkDokter = $conn->select($q);
    
                // set as a doctor
                if (count($checkDokter)) {
                    $data->id_dokter = $checkDokter[0]->id;
                    $data->group = '2000';
                    $data->save();
                }
    
                $user = Web_user::where('email', 'ILIKE', $email)->first();
                echo "New Email",$email ."\n";
                continue ;
            }
            $user->group = $group;
            $user->save();
            echo $email ."\n";
        }
        return 1;
    }
}
